<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Trusthub
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Trusthub\V1\TrustProducts;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Stream;
use Twilio\Values;
use Twilio\Version;


class TrustProductsChannelEndpointAssignmentList extends ListResource
    {
    /**
     * Construct the TrustProductsChannelEndpointAssignmentList
     *
     * @param Version $version Version that contains the resource
     * @param string $trustProductSid The unique string that we created to identify the CustomerProfile resource.
     */
    public function __construct(
        Version $version,
        string $trustProductSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'trustProductSid' =>
            $trustProductSid,
        
        ];

        $this->uri = '/TrustProducts/' . \rawurlencode($trustProductSid)
        .'/ChannelEndpointAssignments';
    }

    /**
     * Create the TrustProductsChannelEndpointAssignmentInstance
     *
     * @param string $channelEndpointType The type of channel endpoint. eg: phone-number
     * @param string $channelEndpointSid The SID of an channel endpoint
     * @return TrustProductsChannelEndpointAssignmentInstance Created TrustProductsChannelEndpointAssignmentInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $channelEndpointType, string $channelEndpointSid): TrustProductsChannelEndpointAssignmentInstance
    {

        $data = Values::of([
            'ChannelEndpointType' =>
                $channelEndpointType,
            'ChannelEndpointSid' =>
                $channelEndpointSid,
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        $payload = $this->version->create('POST', $this->uri, [], $data, $headers);

        return new TrustProductsChannelEndpointAssignmentInstance(
            $this->version,
            $payload,
            $this->solution['trustProductSid']
        );
    }


    /**
     * Reads TrustProductsChannelEndpointAssignmentInstance records from the API as a list.
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param array|Options $options Optional Arguments
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return TrustProductsChannelEndpointAssignmentInstance[] Array of results
     */
    public function read(array $options = [], int $limit = null, $pageSize = null): array
    {
        return \iterator_to_array($this->stream($options, $limit, $pageSize), false);
    }

    /**
     * Streams TrustProductsChannelEndpointAssignmentInstance records from the API as a generator stream.
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param array|Options $options Optional Arguments
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return Stream stream of results
     */
    public function stream(array $options = [], int $limit = null, $pageSize = null): Stream
    {
        $limits = $this->version->readLimits($limit, $pageSize);

        $page = $this->page($options, $limits['pageSize']);

        return $this->version->stream($page, $limits['limit'], $limits['pageLimit']);
    }

    /**
     * Retrieve a single page of TrustProductsChannelEndpointAssignmentInstance records from the API.
     * Request is executed immediately
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return TrustProductsChannelEndpointAssignmentPage Page of TrustProductsChannelEndpointAssignmentInstance
     */
    public function page(
        array $options = [],
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): TrustProductsChannelEndpointAssignmentPage
    {
        $options = new Values($options);

        $params = Values::of([
            'ChannelEndpointSid' =>
                $options['channelEndpointSid'],
            'ChannelEndpointSids' =>
                $options['channelEndpointSids'],
            'PageToken' => $pageToken,
            'Page' => $pageNumber,
            'PageSize' => $pageSize,
        ]);

        $response = $this->version->page('GET', $this->uri, $params);

        return new TrustProductsChannelEndpointAssignmentPage($this->version, $response, $this->solution);
    }

    /**
     * Retrieve a specific page of TrustProductsChannelEndpointAssignmentInstance records from the API.
     * Request is executed immediately
     *
     * @param string $targetUrl API-generated URL for the requested results page
     * @return TrustProductsChannelEndpointAssignmentPage Page of TrustProductsChannelEndpointAssignmentInstance
     */
    public function getPage(string $targetUrl): TrustProductsChannelEndpointAssignmentPage
    {
        $response = $this->version->getDomain()->getClient()->request(
            'GET',
            $targetUrl
        );

        return new TrustProductsChannelEndpointAssignmentPage($this->version, $response, $this->solution);
    }


    /**
     * Constructs a TrustProductsChannelEndpointAssignmentContext
     *
     * @param string $sid The unique string that we created to identify the resource.
     */
    public function getContext(
        string $sid
        
    ): TrustProductsChannelEndpointAssignmentContext
    {
        return new TrustProductsChannelEndpointAssignmentContext(
            $this->version,
            $this->solution['trustProductSid'],
            $sid
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Trusthub.V1.TrustProductsChannelEndpointAssignmentList]';
    }
}
