<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Manage Document')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Document')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('action-button'); ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Document')): ?>
        <a href="#" data-url="<?php echo e(route('document-upload.create')); ?>" data-ajax-popup="true"
            data-title="<?php echo e(__('Create New  Document Type')); ?>" data-size="md" data-bs-toggle="tooltip" title=""
            class="btn btn-sm btn-primary" data-bs-original-title="<?php echo e(__('Create')); ?>">
            <i class="ti ti-plus"></i>
        </a>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="col-xl-12">
        <div class="card">
            <div class="card-header card-body table-border-style">
                
                <div class="table-responsive">
                    <table class="table" id="pc-dt-simple">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Name')); ?></th>
                                <th><?php echo e(__('Document')); ?></th>
                                <th><?php echo e(__('Role')); ?></th>
                                <th><?php echo e(__('Description')); ?></th>
                                <?php if(Gate::check('Edit Document') || Gate::check('Delete Document')): ?>
                                    <th width="200px"><?php echo e(__('Action')); ?></th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($document->name); ?></td>
                                    <td>
                                        <?php
                                            $documentPath = \App\Models\Utility::get_file('uploads/documentUpload');
                                            $roles = \Spatie\Permission\Models\Role::find($document->role);
                                        ?>
                                        <?php if(!empty($document->document)): ?>
                                            <div class="dt-buttons">
                                                <span>
                                                    <div class="action-btn bg-primary me-2">
                                                        <a class="mx-3 btn btn-sm align-items-center" data-bs-toggle="tooltip"
                                                    data-bs-original-title="<?php echo e(__('Download')); ?>"
                                                            href="<?php echo e($documentPath . '/' . $document->document); ?>"
                                                            download>
                                                            <span class="text-white"><i class="ti ti-download"></i></span>
                                                        </a>
                                                    </div>
                                                    <div class="action-btn bg-secondary ">
                                                        <a class="mx-3 btn btn-sm align-items-center"
                                                            href="<?php echo e($documentPath . '/' . $document->document); ?>"
                                                            target="_blank">
                                                            <span class="text-white"><i class="ti ti-crosshair"
                                                                    data-bs-toggle="tooltip"
                                                                    data-bs-original-title="<?php echo e(__('Preview')); ?>"></i></span>
                                                        </a>
                                                    </div>
                                                </span>
                                            </div>
                                                <?php else: ?>
                                                    <p>-</p>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(!empty($roles) ? $roles->name : 'All'); ?></td>
                                    <td>
                                        <p
                                            style="white-space: nowrap;
                                            width: 200px;
                                            overflow: hidden;
                                            text-overflow: ellipsis;">
                                            <?php echo e($document->description); ?>

                                        </p>
                                    </td>
                                    <td class="Action">
                                        <div class="dt-buttons">
                                            <span>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Edit Document')): ?>
                                                    <div class="action-btn bg-info me-2">
                                                        <a href="#" class="mx-3 btn btn-sm  align-items-center"
                                                            data-url="<?php echo e(route('document-upload.edit', $document->id)); ?>"
                                                            data-ajax-popup="true" data-size="md" data-bs-toggle="tooltip"
                                                            title="" data-title="<?php echo e(__('Edit Document')); ?>"
                                                            data-bs-original-title="<?php echo e(__('Edit')); ?>">
                                                            <span class="text-white"><i class="ti ti-pencil"></i></span>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>

                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Delete Document')): ?>
                                                    <div class="action-btn bg-danger">
                                                        <?php echo Form::open([
                                                            'method' => 'DELETE',
                                                            'route' => ['document-upload.destroy', $document->id],
                                                            'id' => 'delete-form-' . $document->id,
                                                        ]); ?>

                                                        <a href="#" data-size="lg"
                                                            class="mx-3 btn btn-sm  align-items-center bs-pass-para"
                                                            data-bs-toggle="tooltip" title=""
                                                            data-bs-original-title="Delete" aria-label="Delete"><span
                                                                class="text-white"><i class="ti ti-trash"></i></span></a>
                                                        </form>
                                                    </div>
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/donrrvzg/hr.donrexluxuryapartments.com/resources/views/documentUpload/index.blade.php ENDPATH**/ ?>